<?php

/*
 * AIT WordPress Theme
 *
 * Copyright (c) 2013, Affinity Information Technology, s.r.o. (http://ait-themes.com)
 */

// === Usefull debugging constants ===================================

// if(!defined('AIT_DISABLE_CACHE')) define('AIT_DISABLE_CACHE', true);
// if(!defined('AIT_ENABLE_NDEBUGGER')) define('AIT_ENABLE_NDEBUGGER', true);


// === Loads AIT WordPress Framework ================================
require_once get_template_directory() . '/ait-theme/@framework/load.php';


// === Mandatory WordPress Standard functionality ===================

if(!isset($content_width)) $content_width = 1200;


/* THEME UPGRADE FUNCTIONS */

add_action('ait-theme-upgrade', function($upgrader){
	if(version_compare($upgrader->getThemeVersion(), '1.39', '<')){

		$upgradeThemeFn = function(){
			$errors = array();

			// do the logic here
			add_action( 'init', function(){
				foreach($GLOBALS['wp_registered_widgets'] as $widget){
					if(!empty($widget['callback'][0]) and !empty($widget['params'][0]['number'])){
						$obj = $widget['callback'][0];

						if(
							is_object($obj) and
							method_exists($obj, 'get_settings') and
							method_exists($obj, 'save_settings') and
							in_array($obj->id_base, array('ait-baner'))
						){
							$settings = $obj->get_settings();
							$number = $widget['params'][0]['number'];
							$newSettings = $settings;
							if(is_numeric($number) and isset($settings[$number])){
								foreach($settings[$number] as $key => $value){
									$newKey = $key;
									if(AitUtils::endsWith($key, '_all')){
										$newKey = substr($key, 0, -4);
									}else{
										$suffix = substr($key, -3, 3);
										if(AitUtils::startsWith($suffix, '_')){
											$newKey = substr($key, 0, -3);
										}
									}
									$newSettings[$number][$newKey] = $value;
									unset($newSettings[$number][$key]);
								}
								$obj->save_settings($newSettings);
							}
						}
					}
				}
			} );
			// do the logic here
			return $errors;
		};

		$upgrader->addErrors($upgradeThemeFn());
	}
});

/* THEME UPGRADE FUNCTIONS */


// === Run the theme ===============================================

$themeConfiguration = include aitPath('config', '/@theme-configuration.php');

AitTheme::run($themeConfiguration);


// === Custom settings ==============================================


if ( aitIsPluginActive( "woocommerce" ) ) {
	
	add_filter('loop_shop_columns', function() { return 3; });

	// Display 6 products per page
	//add_filter('loop_shop_per_page', function($cols){ return 6; }, 20);

	// Add image sizes for woocommerce 3.3+
	add_theme_support( 'woocommerce', array(
	    'thumbnail_image_width'         => 500,
	    'gallery_thumbnail_image_width' => 180,
	    'single_image_width'            => 750,
	) );

	// Change number of related products on product page
	// Set your own value for 'posts_per_page'
	add_filter( 'woocommerce_output_related_products_args', 'ait_related_products_args' );
	function ait_related_products_args( $args ) {
		$args['posts_per_page'] = 3; // 3 related products
		$args['columns'] = 3; // arranged in 3 columns
		return $args;
	}

	// Disable woocommerce default styles
	if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
		add_filter( 'woocommerce_enqueue_styles', '__return_false' );
	} else {
		define( 'WOOCOMMERCE_USE_CSS', false );
	}
}


// === Custom filters, actions for framework overrides ==============

require_once aitPath('includes', '/custom-functions.php');
