<!doctype html>
<!--[if IE 8]>
<html {languageAttributes}  class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass} ie ie8">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)]><!-->
<html {languageAttributes} class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass}" style="background-image: url({!$options->layout->custom->pageHtmlBackground->image}); background-color: {!$options->layout->custom->pageHtmlBackground->color}; background-repeat: {$options->layout->custom->pageHtmlBackground->repeat}; background-position: {$options->layout->custom->pageHtmlBackground->position}; background-attachment: {$options->layout->custom->pageHtmlBackground->scroll};">
<!--<![endif]-->
<head>
	<meta charset="{$wp->charset}">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="{$wp->pingbackUrl}">

	{if $options->theme->general->favicon != ""}
		<link href="{$options->theme->general->favicon}" rel="icon" type="image/x-icon" />
	{/if}

	{includePart parts/seo}

	{googleAnalytics $options->theme->google->analyticsTrackingId, $options->theme->google->anonymizeIp}

	{wpHead}

	{!$options->theme->header->customJsCode}
</head>
<body class="{!$wp->bodyHtmlClass(false)} layout-narrow">
	{* usefull for inline scripts like facebook social plugins scripts, etc... *}
	{doAction ait-html-body-begin}

	<div id="page" class="hfeed">
		<div class="page-container head">
			<header id="masthead" class="site-header" role="banner">
				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{!$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<div class="site-title"><a href="{$homeUrl}" title="{!$wp->name}" rel="home">{!$wp->name}</a></div>
						{/if}
						<p class="site-description">{!$wp->description}</p>
					</div>

					<div class="header-items">
						{includePart parts/header-items}
					</div>

					<div class="site-tools">

					<!--	<div class="site-search">
							{searchForm}
						</div> -->

						{includePart parts/social-icons}

						
						{includePart parts/languages-switcher}

						{includePart "parts/woocommerce-cart"}

					</div>

				</div>

				<div class="menu-container">

						<nav class="main-nav" role="navigation">
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'}</h3>
								{menu main}
							</div>
						</nav>

				</div>
			</header><!-- #masthead -->

			<div class="sticky-menu menu-container" >

					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{!$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<div class="site-title"><a href="{$homeUrl}" title="{!$wp->name}" rel="home">{!$wp->name}</a></div>
						{/if}
					</div>
					<nav class="main-nav">
						<!-- wp menu here -->
					</nav>

			</div>
		</div>

