<?php
/**
 * This file contains all the functions related to this particular theme.
 */

//Customize excerpt word count
function custom_excerpt_length() {
    return 25; //25 words
}

add_filter('excerpt_length', 'custom_excerpt_length');

function posts_link_next_class($format){
    $format = str_replace('href=', 'class="btn btn-primary" href=', $format);
    return $format;
}
add_filter('next_post_link', 'posts_link_next_class');

function posts_link_prev_class($format) {
    $format = str_replace('href=', 'class="btn btn-primary" href=', $format);
    return $format;
}
add_filter('previous_post_link', 'posts_link_prev_class');
 

/*-------------------------------------------*/
/* Image Processing fucntions 
/*--------------------------------------------*/
 
/*
 * Gets the image id by providing and URL.
 */
function get_image_id($image_url) {
    global $wpdb;
    $attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url ));
    return $attachment != false ? $attachment[0] : false;
}


// Get Resized image from url
function get_resized_image_from_id($id, $image_name='full'){
	
	/**
		@param
		$id = id
		$image_name = Resized image name from add_image_size()
	*/	
 		
	global $wpdb;
	
	$image =  wp_get_attachment_image_src( get_post_thumbnail_id($id), $image_name);
	 
	if(empty($image)){
		$image = wp_get_attachment_image_src( get_post_thumbnail_id($id), 'full');
	}
	return $image; 
  }

/*
 * Returns the URL of an image size by providing the URL to the original size.
 */
function get_resized_only_image_from_url($url, $size_name) {
    $attachment_id = get_image_id($url);
    if($attachment_id != false) {
		$image_src =  wp_get_attachment_image_src($attachment_id, $size_name);
	    return $image_src!= false ? $image_src[0] : $url;
    } else {
        return $url;
    }
}

/*
 * Returns the image array from image default url.
 */
function get_resized_image_from_url($url, $size_name) {
	
	/**
		@param $image_url $size_name
		@return $image = array
	*/
	
    $attachment_id = get_image_id($url);
    if($attachment_id != false) {
		// image array
		return $image =  wp_get_attachment_image_src($attachment_id, $size_name);
	}
	else return $url = array( 
				0 => $url,
				1 => 'auto',
				2 => 'auto',	
		)
	;

} 

if ( ! function_exists( 'navthemes_entry_meta' ) ) : 
   
/**
 * Set up post entry meta.
 */
function navthemes_entry_meta() {
	
	// Translators: used between list items, there is a space after the comma.
	$categories_list = '<span class="category" itemprop="articleSection"><i class="fa fa-bookmark"></i>'. get_the_category_list( __( ', ', 'air-free' ) ) . "</span>";
  

	$date = sprintf( '<span class="date"><i class="fa fa-clock-o"></i> <a href="%1$s" title="%2$s" rel="bookmark"><time itemprop="datePublished" datetime="%3$s">%4$s</time></a></span>',
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() )
	);

	$author = sprintf( '<span itemprop="author"><i class="fa fa-user"></i> <span class="author"><a href="%1$s" title="%2$s" rel="">%3$s</a></span></span>',
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_attr( sprintf( __( 'View all posts by %s', 'air-free' ), get_the_author() ) ),
		get_the_author()
	);
	
	$comment_number = get_comments_number();
	$comment_number = sprintf( _n( '1 Comment', '%s Comments', $comment_number, 'air-free' ), $comment_number );
	$comment_number =  sprintf( ' <span class="comments" itemprop="interactionCount"> <i class="fa fa-comment"></i><a href="%1$s" title="%2$s" rel="comments">%2$s</a></span>',
		get_comments_link(),
		$comment_number
	);

  
  	// Translators: used between list items, there is a space after the comma.
	$tag_list = '<span class="tags"> <i class="fa fa-tags"></i> '. get_the_tag_list( '', __( ', ', 'air-free' ) ). '</span>';

	$utility_text = __( ' %1$s %3$s %4$s %5$s %2$s ', 'air-free' );	
	
  	// Translators: 1 is category, 2 is tag, 3 is the date, 4 is the author's name and 5 is comments.
	echo $categories_list ;
	echo $date ;
	echo $author ;
	echo $comment_number ;
	echo $tag_list ;
 }

endif;


/* -------------------------------------------------*/
	// Advance Code 
/*---------------------------------------------------*/	
	function navthemes_add_footer(){	
	 	// Pre-loader
		 if(get_theme_mod('pre_loader_switch', 1)) {
			  $pre_loader_html = '	 
				<!--PRE LOADER HERE-->
				<div id="pre-loader">
					<div class="spinner">
						<div class="double-bounce1"></div>
						<div class="double-bounce2"></div>
					</div>
				</div>
				<script>
					/* Window LOAD */
					jQuery(window).load(function() {
						jQuery("#pre-loader").fadeOut();
						jQuery("#main_container").fadeIn();
						jQuery("#main_container").css("opacity","1");
					});
				</script>';
				echo $pre_loader_html;
				
		}
	}// Function
	
	add_action('wp_footer','navthemes_add_footer');