<?php
/**
 * This file is responsible for the rendering of the header of the theme.
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>	
    <link rel="profile" href="http://gmpg.org/xfn/11">
	 <script data-cfasync="false"> 
		// Custome JS from Options	
		var NT_CustomJS = {floatmenu:"<?php echo get_theme_mod('floatmenu',1); ?>", homepage_topslider_interval:<?php echo get_theme_mod('homepage_topslider_interval', 3)*1000; ?>};
     </script>
<?php
    wp_head();
	
	// Pre-loader opacity
    $pre_loader = get_theme_mod('pre_loader_switch', 1) ? "" : $pre_loader = "visible"; 
	
	// Tracking code
	echo get_theme_mod('tracking_code');
    ?>
      <!--[if IE]>
          <style type="text/css">
                .os-animation{
                    opacity:1;
                    /* IE 8 */
                    -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
                    /* IE 5-7 */
                    filter: alpha(opacity=100);
                }
              </style>     
  	<![endif]-->  
    
</head>
<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage" id="body">
  <?php
  
  	$layout = maybe_unserialize( get_theme_mod( 'onepage_modules', array( 'welcome', 'pages' , 'statistics', 'services', 'testimonials',) ) ); 
				
  
    $menu_args = array(
        'menu' => get_theme_mod('nav_menu_name'),
        'container' => '',
        'menu_class' => '',
        'items_wrap' => '%3$s',
        'walker' => new Navthemes_Nav_Menu()
    );

    $modules = array(

			'welcome' =>array(
			'show' => get_theme_mod('showin_menu_welcome', 0), 
			'text' => get_theme_mod('welcome_menu_title', 'Welcome'),
			'link' => '#welcome'
		), 
	 
 			'pages' =>array(
			'show' => get_theme_mod('showin_menu_pages', 1), 
			'text' => get_theme_mod('pages_menu_title', 'Pages'),
			'link' => '#pages'
		), 
	 
 			'statistics' =>array(
			'show' => get_theme_mod('showin_menu_statistics', 1), 
			'text' => get_theme_mod('statistics_menu_title', 'Statistics'), 
			'link' => '#statistics'
		),
	
			'services' =>array(
			'show' => get_theme_mod('showin_menu_services', 1), 
			'text' => get_theme_mod('services_menu_title', 'Services'), 
			'link' => '#services'
		),
	 
			'testimonials' =>array(
			'show' => get_theme_mod('showin_menu_testimonial', 1), 
			'text' => get_theme_mod('testimonials_menu_title', 'Testimonials'), 
			'link' => '#testimonials'
		),
     );
	
?>
<div id="main_container" class="<?php echo $pre_loader; ?>">
<?php
if(!is_404()) { ?>
 <script>$ = jQuery;</script>    
    <header itemscope itemtype="http://schema.org/WPHeader">
        <!--header_warpper-->
        <div class="header_wrapper">
            <?php
            if (is_front_page() && get_theme_mod('homepage_topslider_visible', 1)) {
                    get_template_part('header','front'); 
              }
            ?>
            <!-- Menu Wrapper -->
            <div id="nav_wrapper" class="menu_wrapper">
                <div class="container">
                    <div id="logo" class="text-center pull-left">
                        <?php 
                            echo is_front_page() ? '<h1 class="site-title">' : '<p class="site-title">';  
                        ?>
                        <a href="<?php echo home_url(); ?>" class="logo pull-left">
                        <?php 
                         if(get_theme_mod('logo')){ 
                            $logo = get_resized_image_from_url(get_theme_mod('logo'),'logo'); 
                         ?>
                           <img class="logo" width=" <?php echo $logo[1]; ?>" height=" <?php echo $logo[2]; ?>" src="<?php echo $logo[0]; ?> " />
                        <?php } else {  
                         bloginfo('name', 'air-free'); 
                        }?>
                        </a>
                       <?php 
                        echo is_front_page() ? '</h1>' : '</p>';  
                       ?>
          
          </div>
                    <nav class="text-center pushy pushy-left">
                      <ul class="pull-right" itemtype="https://schema.org/SiteNavigationElement">
                            <li class="page-scroll"><a href="<?php echo is_front_page() ? '#home' : get_site_url(); ?>"><?php _e('Home', 'air-free'); ?></a></li>
                            <?php
                         if (get_theme_mod('nav_menu_position','after') == 'before') 
                        {
                           if (get_theme_mod('nav_menu_name', 'none') != 'none') {
                                wp_nav_menu($menu_args);
                            }
                        }
                        
                        if(get_theme_mod('one_page_switch', 1)):
                
                      if ( ! empty( $layout ) ) : ?>
                        <?php
                          foreach ($layout as $checked_value) {
                            if ($modules[$checked_value]['show']) {
                                ?>
                                <li class="page-scroll">
                                    <a itemprop="url" href="<?php echo (!is_front_page() ? get_site_url().'/' : '') . $modules[$checked_value]['link']; ?>">
                                        <span itemprop="name"><?php echo $modules[$checked_value]['text']; ?></span>
                                    </a>
                                </li>
                            <?php
                            }
                        } ?>
                     <?php endif; // if not empty sorter
                        endif; // if one page switch
                        
                       if (get_theme_mod('nav_menu_position','after') == 'after') {
                            if (get_theme_mod('nav_menu_name', 'none') != 'none') {
                                wp_nav_menu($menu_args);
                            }
                        }
                        ?>
                        </ul>
                    </nav>
                </div>
            
            <div class="menu-btn">&#9776; Menu</div>
             <div class="site-overlay"></div>
            
            </div>
            <!-- Menu Wrapper -->
            <?php
           if(!is_front_page() ) {
                get_template_part('header','inner');
            }
            ?>
            <div class="clearfix"></div>
        </div>
        <!--header_warpper end-->
    </header>
<?php
} // if !404
?>