<?php

class Navthemes_Comments_Walker extends Walker_Comment {

    public function start_el(&$output, $comment, $depth=0, $args=array(), $id = 0) {
        $GLOBALS['comment'] = $comment;
        $depth_class = empty($args['has_children']) ? '' : ' col-xs-offset-'.$depth;

        $output .= '<div id="comment-'.$comment->comment_ID.'" class="col-md-11'.$depth_class.' comment-row">';
        $output .= '<div class="col-md-1 no-padding">';
        $output .= '<img class="comment_img" src="'.get_avatar_url(get_comment_author_email(), array('size'=>64)).'" alt="">';
        $output .= '</div>';
        $output .= '<div class="col-md-11 no-padding">';
        $output .= '<h3>'.get_comment_author().'</h3>';
        $output .= '<div class="comment-meta">';
        $output .= '<i class="fa fa-comments"></i>';
        $output .= '<span><a href="'.htmlspecialchars(get_comment_link()).'">'.get_comment_date().' '.__('at', 'air-free').' '.get_comment_time().'</a></span>';
        $output .= ' <i class="fa fa-pencil"></i> <span>'.get_comment_reply_link(array('reply_text' => __('Reply', 'air-free'), 'depth' => 1, 'max_depth' => get_option('thread_comments_depth')), $comment, $comment->comment_post_ID).'</span>';
		$output .= '</div>';
        if(!$comment->comment_approved) {
            $output .= '<p><em>' . __('This comment is not yet approved', 'air-free') . '</em></p>';
        } else {
            $output .= '<p>' . get_comment_text() . '</p>';
        }
        $output .= '<div class="clearfix"></div>';
        $output .= '<div class="space"></div>';
        $output .= '</div>';
	 }

    public function end_el(&$output, $comment, $depth=0, $args=array(), $id = 0) {
        $output .= '</div>';

    }

}