<?php
/**
 * This file contains all the functions related to the Wordpress platform.
 */ 

//Set some backward compatibility
if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

//Set the content width
if ( ! isset( $content_width ) ) $content_width = 900;
/**
 * A helper function to get the path to the assets.
 *
 * @param $path
 * @return string
 */
function getAssetsPath($path) {
    return get_template_directory_uri() . '/assets/' . $path;
}

/**
 * A helper function to get the path to an image.
 *
 * @param $name
 * @return string
 */
function image($name) {
    return getAssetsPath('img/'.$name);
}


//  Google Font

if ( ! function_exists( 'air_fonts_url' ) ) :

function air_fonts_url() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
    $Montserrat = _x( 'on', 'Montserrat font: on or off', 'air-free' );
 
        $font_families = array();
 
        if ( 'off' !== $Montserrat ) {
            $font_families[] = 'Montserrat:400,700';
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}

endif;


if ( ! function_exists( 'air_styles' ) ) :

/**
 * This function will enqueue all the styles the theme uses.
 */
function air_styles() {
    
	//Load the needed fonts from Google    
	wp_enqueue_style( 'air-google-font', air_fonts_url(), array(), null );

    //Load the latest compiled and minified version of Twitter Bootstrap's stylesheet
    wp_enqueue_style('air-bootstrap', getAssetsPath('bootstrap/css/bootstrap.min.css'));

    //Load Font CSS
    wp_enqueue_style('air-font-awesome', getAssetsPath('custom/css/font-awesome.min.css'));
	
    //Animnate CSS
    wp_enqueue_style('air-animate', getAssetsPath('custom/css/animate.css'));

    wp_enqueue_style('air-main', get_stylesheet_uri());
  
    //If the page is not 404 load those styles
    if(!is_404()) {
        //Important Owl stylesheet
        wp_enqueue_style('air-owl-carousel', getAssetsPath('owl-carousel/owl.carousel.css'));
        //Default Theme
        wp_enqueue_style('air-owl-theme', getAssetsPath('owl-carousel/owl.theme.css'));
		
		// Menu 
        wp_enqueue_style('air-pushy-menu', getAssetsPath('pushy-menu/css/pushy.css'));
  
    }
}

endif;

add_action('wp_enqueue_scripts', 'air_styles');


if ( ! function_exists( 'air_scripts' ) ) :

/**
 * This function will enqueue all the scripts the theme uses.
 */
function air_scripts() {
    //Load html5shim
    wp_enqueue_script('air-html5shim', getAssetsPath('require/html5.js'));
    wp_script_add_data('air-html5shim', 'conditional', 'lt IE 9');

    //Load respond.js
    wp_enqueue_script('air-respond',  getAssetsPath('require/respond.min.js') );
    wp_script_add_data('air-respond', 'conditional', 'lt IE 9');
 

    if(is_singular() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    //If the page is not 404 load those scripts
    if(!is_404()) {
        //Load Bootstrap's js
        wp_enqueue_script('air-bootstrap', getAssetsPath('bootstrap/js/bootstrap.min.js'), array('jquery'));

        //Load owl-carousel js
        wp_enqueue_script('air-owl-carousel', getAssetsPath('owl-carousel/owl.carousel.js'), array('jquery') ,NULL, true);

        //For Page Scrolling js
        wp_enqueue_script('air-jquery-easing', getAssetsPath('custom/js/jquery.easing.min.js'), array('jquery') ,NULL, true);

        //Scroll BAR js
        wp_enqueue_script('air-scrollbar', getAssetsPath('scroll/jquery.scrollbar.js'), array('jquery') ,NULL, true);

        //Waypoints
        wp_enqueue_script('air-waypoints', getAssetsPath('custom/js/waypoints.min.js'), array('jquery'));

        //Scripts loaded in footer (after page load)
       	
		// Pushy
		wp_enqueue_script('pushy-js', getAssetsPath('pushy-menu/js/pushy.min.js'), array( 'jquery' ) ,NULL, true);

		
        //Google Maps API
        wp_enqueue_script('air-google-maps-api', 'https://maps.googleapis.com/maps/api/js?v=3.exp', array('jquery'), NULL, true);

        //Custom
        wp_enqueue_script('air-custom', getAssetsPath('custom/js/custom.js'), array('jquery'), NULL, true);

        //Load those only if loading the homepage
        if (is_front_page()) {
            //For Portfolio
            wp_enqueue_script('air-freewall', getAssetsPath('custom/js/freewall.js'), array('jquery'), NULL, true);
 
            //CountTo
            wp_enqueue_script('air-counto', getAssetsPath('countTo/jquery.countTo.js'), array('jquery'), NULL, true);
        }
    }
}

endif;

//Let's bind those functions...
add_action('wp_enqueue_scripts', 'air_scripts');


/*-------------------------------------------------------*/
/* Rocket Loader fix
/*-------------------------------------------------------*/
add_filter('script_loader_tag','rocket_loader_fix',10,2);
function rocket_loader_fix($tag, $handle){
	
	//if($handle=="air-google-maps-api") 
		return str_replace( ' src', ' data-cfasync="false" src', $tag );
	//else 
	//return str_replace( ' src', ' src', $tag ); 
}


if ( ! function_exists( 'air_setup' ) ) :

function air_setup() {
	
	// Translation
	load_theme_textdomain('air-free', get_template_directory() . '/languages');

    //Navigation Menus
    add_theme_support('menus');

    //Add featured image support
    add_theme_support('post-thumbnails', array('page', 'portfolio'));

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');

    //Custom header is an image that is chosen as the representative image in the theme top header section.
    //add_theme_support('custom-header');

    //Custom Backgrounds is a theme feature that provides for customization of the background color and image.
    //add_theme_support('custom-background');

    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );

    //Allow pages, posts and portfolios to have excerpts.
    add_post_type_support('portfolio', 'excerpt');
	
	// Top Slider 
	add_image_size('top_bg', 1000, 600, true);
	
    //Register custom image sizes
	add_image_size('logo', 70, 28, true);
    
    add_image_size('pages', 673, 470, true);
    add_image_size('team', 203, 272);
  
    add_image_size('portfolio', 300, 3000000);
	//add_image_size('portfolio', 285,252);
	add_image_size('portfolio_big', 350, 233);
 	
    add_image_size('testimonials', 150, 150);
    add_image_size('testimonials_side', 952, 636, true);
    add_image_size('contacts', 952, 921, true);
     
	add_theme_support( 'post-thumbnails' ); 
	set_post_thumbnail_size( 1140, 400, true );
	
	add_image_size('blog-post-shortcode', 303, 202, true);
	
}

endif;

add_action('after_setup_theme', 'air_setup');


/*----------------------------------------*/
/* Includes	
/*----------------------------------------*/

// Nav Menu
require_once dirname(__FILE__).'/classes/Navthemes_Nav_Menu.php';

//NavThemes Functions.
require_once dirname(__FILE__).'/navthemes_functions.php';

//Theme options
require_once dirname(__FILE__).'/theme-options.php';
