<?php
/**
 * This file is responsible for the rendering of a 404 error page.
 */
get_header();
?>
<div class="content-wrap">
    <div class="error_page">
        <div class="container">
            <h2><?php _e('Error 404!', 'air-free'); ?></h2>
            <div class="error_bottom_border"></div>
            <p><?php _e('The requested page does not exist.', 'air-free'); ?></p>

            <div id="search">
            <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input placeholder="<?php _e('Search here...', 'air-free'); ?>" name="s" id="s" type="text"  autocomplete="off">
            </form>    
            </div>
            <div class="back_button">
                <div class="pre_btn"><a href="javascript:history.back()" class="btn btn-primary"><?php _e('Back', 'air-free'); ?></a></div>
            </div>
        </div>

    </div>

    <footer class="error_bottom footer_wrapper">

        <div class="container">

            <div class="clearfix"></div>
            <div class="social">
    
              <?php if(get_theme_mod('social_facebook', '#')): ?>
				<a itemprop="sameAs" target="_blank" href="<?php echo esc_url(get_theme_mod('social_facebook' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-facebook"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_twitter', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_twitter' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-twitter"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_pinterest', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_pinterest' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-pinterest"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_tumblr', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_tumblr' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-tumblr"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_youtube', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_youtube' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-youtube"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_google_plus', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_google_plus' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-google-plus"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_instagram', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_instagram' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-instagram"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_linkedin', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_linkedin' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-linkedin"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_vimeo', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_vimeo' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-vimeo-square"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_tumblr', '#')): ?>
				<a itemprop="sameAs" target="_blank"  href="<?php echo esc_url(get_theme_mod('social_tumblr' , '#'), 'air-free'); ?>" class="social_icon"><i class="fa fa-tumblr"></i></a>
			<?php endif; ?>
		   
			<?php if(get_theme_mod('social_email', '#')): ?>
				<a itemprop="sameAs" href="<?php echo 'mailto:'.get_theme_mod('social_email' , '#'); ?>" class="social_icon"><i class="fa fa-envelope"></i></a>
              <?php endif; ?>

            </div>

            <div class="copyright">
            	<p>
                     <?php
                     if(get_theme_mod('footer_copyright')) {
						echo get_theme_mod('footer_copyright');
					}
                    ?>
            	</p>
            </div>
        </div>
    </footer>
</div> <!-- .content-wrap -->
</main>
<?php 