<?php
/**
	This File handles Customizer Options
*/
$themename = "AIR";
$pro_link = "http://www.navthemes.com/air-one-page-multipurpose-theme/";
$themes_link = "http://www.navthemes.com/wp-themes/";
$support = "http://navthemes.com/users/signup/rsOSrXFBK";

// Pro message
$pro_message = sprintf(__('<div class="section-heading"><a href="%s" target="_blank"> This is a pro feature, Please <br/> <span> Upgrade to pro </span> </a></div>', 'air-free'), $pro_link);


$no_elements = 3;


include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}

/*---------------------------------
	Nav Menu
----------------------------------*/

$nav_menus = array('none' => __('None', 'air-free'));
$wp_nav_menu_list = get_terms('nav_menu', array('hide_empty' => true));

foreach($wp_nav_menu_list as $menuItem) {
    $nav_menus[$menuItem->slug] = $menuItem->name;
}
 
/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}
add_filter( 'kirki/config', 'navthemes_configuration' );

/*------------------------------------------
	Config	- Deprecated
  ------------------------------------------*/
/*
Kirki::add_config( 'air-free', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );*/

	/*------------------------------------------
		 NavThemes Branding
	 ------------------------------------------*/
 
 	Kirki::add_section( 'navthemes_section', array(
			'title'          => __( 'NavThemes Support', 'air-free' ),
			'priority'       => 1,
	) );
			
		Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'description'    => sprintf(__('<strong> You are using Free version of %s Theme, Check out Paid version, which comes with Premium support and many exciting features in the package.</strong>', 'air-free'),  $themename),
		'settings'     => 'navthemes_support',
		'section'     => 'navthemes_section',
		'default'     => sprintf(__('<div id="navthemes_branding"><h1>%s</h1>
			<div class="navthemes-links">
			<ul>
				<li><a target="_blank" href="%s">Check out All Features of Paid version</a></li>
				<li><a target="_blank" href="%s">View All Our Themes</a></li>
				<li><a target="_blank" href="%s">Support</a></li>
			</ul> 
		</div>
		</div>', 'air-free'),
			"Upgrade to Pro Version for Just $59",
			$pro_link,
			$themes_link,
			$support
			),
		'priority'    => 10,
	) );		
		 

/*------------------------------------------
	Home Page Panel	
 ------------------------------------------*/

	Kirki::add_panel( 'homepage', array(
		'priority'    => 10,
		'title'       => __( 'Module Manager', 'air-free' ),
		'description' => __( 'Manage Front Page Setting from here', 'air-free' ),
		'capability'     => 'edit_theme_options',
	
	) );
	
	
	/*----------------------------------
		Top Slider Setting
	*----------------------------------*/

	Kirki::add_section( 'topslider_settings', array(
		'title'          => __( 'Top Slider Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Top Slider Settings' , 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );

	Kirki::add_field( 'air-free', array(
		'settings' => 'homepage_topslider_visible_pro_message',
		'label'    => __( 'Top slider Visibility', 'air-free' ),
		'section'  => 'topslider_settings',
		'type'     => 'custom',
		'default'     => $pro_message,
		'priority'    => 10,
	) );
		
		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_topslider_image',
				'label'    => __( 'Top slider Background Image', 'air-free' ),
				'section'  => 'topslider_settings',
				'type'     => 'image',
				'priority' => 10,
				'default' => image('banner_bg.jpg'),
			) );	


		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_topslider_interval',
				'label'    => __( 'Slide Interval', 'air-free' ),
				'description' => __("The time in seconds between two slides.", 'air-free'),
				'section'  => 'topslider_settings',
				'type'     => 'text',
				'priority' => 10,
				'default' => '3',
			) );	
/*	
		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_topslider_pagintion',
				'label'    => __( 'Slide Pagination', 'air-free' ),
				'description' => __("Whether or not the slider's pagination will show.", 'air-free' ),
				'section'  => 'topslider_settings',
				'type'     => 'toggle',
				'priority' => 10,
				'default' => 1,
			) );	
				*/

		Kirki::add_field( 'air-free', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Top Slider Slides', 'air-free' ),
		'description' => __( '<b>Add Slides here</b>' , 'air-free' ),
		'section'     => 'topslider_settings',
		'priority'    => 10,
		'settings'    => 'topslider_slides',
 		'fields' => array(
			'slide_title' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Slide Title', 'air-free' ),
				'description' => esc_attr__( 'This will be the title for your Slide', 'air-free' ),
				'default'     => '',
			),
			'slide_desc' => array(
				'type'        => 'textarea',
				'label'       => esc_attr__( 'Slide Description', 'air-free' ),
				'description' => esc_attr__( 'This will be the icon for your Slide', 'air-free' ),
				'default'     => '',
			),
			'slide_link' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Slide Link', 'air-free' ),
				'description' => esc_attr__( "This will be the link of Slide Read More button, if you will leave it empty, read more button won't show.", 'air-free' ),
				'default'     => '',
			),
		)
	) );


	/*----------------------------------
		Welcome Settings
	*----------------------------------*/
		
	Kirki::add_section( 'welcome_settings', array(
		'title'          => __( 'Welcome Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Welcome Module Settings' , 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
		
 		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_welcome_title',
				'label'    => __( 'Section Title', 'air-free' ),
				'description' => __("The title will show at the top of the section with a bigger font size.", 'air-free'),
				'section'  => 'welcome_settings',
				'type'     => 'text',
				'priority' => 10, 
			) );	
 		
 		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_welcome_text',
				'label'    => __( 'Section Title', 'air-free' ),
				'description' => __("This text will show below the title. HTML is allowed.", 'air-free'),
				'section'  => 'welcome_settings',
				'type'     => 'textarea',
				'priority' => 10, 
			) );	
 
 		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_welcome_link',
				'label'    => __( 'Read More URL', 'air-free' ),
				'description' => __('If you enter a URL, a "Read More" button will appear.', 'air-free'),
				'section'  => 'welcome_settings',
				'type'     => 'text',
				'priority' => 10,
				'default' => __('#pages', 'air-free'),
			) );
 	
 
 	/*------------------------------------------
		About us Module
  	------------------------------------------*/
		
	Kirki::add_section( 'aboutus', array(
		'title'          => __( 'About us Settings', 'air-free' ),
		'description'    => __( 'From here you can manage About us Module elements', 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
	) );
 	
	
	/*------------------------------------------
		Add Fields to Home Page Section
	------------------------------------------*/
	 
	 	Kirki::add_field( 'air-free', array(
			'settings' => 'showin_menu_pages',
			'label'    => __( 'Show in Menu ? ', 'air-free' ),
			'section'  => 'aboutus',
			'type'     => 'toggle',
			'default'     => 1,
			'priority' => 10,
		) );	
	 
	 	Kirki::add_field( 'air-free', array(
				'settings' => 'pages_menu_title',
				'label'    => __( 'About us Menu Text ', 'air-free' ),
				'section'  => 'aboutus',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'About us',
			) );	
			 
 	 	/*1st ---------------------------------------*/
			
			Kirki::add_field( 'air-free', array(
					'type'        => 'custom',
					'settings'     => 'aboutus_heading1',
					'section'     => 'aboutus',
					'default'     => '<div class="section-heading">About us 1<sup>st</sup> Block</div>',
					'priority'    => 10,
				) );
					
			Kirki::add_field( 'air-free', array(
					'settings' => 'aboutus_label1',
					'label'    => __( 'About us Label 1 ', 'air-free' ),
					'section'  => 'aboutus',
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				) );
					
			Kirki::add_field( 'air-free', array(
					'settings' => 'aboutus_desc1',
					'label'    => __( 'About us Description 1 ', 'air-free' ),
					'section'  => 'aboutus',
					'type'     => 'textarea',
					'priority' => 10,
					'default'  => '',
				) ); 				
			
			Kirki::add_field( 'air-free', array(
					'settings' => 'aboutus_link1',
					'label'    => __( 'About us Read More Link 1 ', 'air-free' ),
					'description' => __("Read More won't show if its empty.",'air-free'),
					'section'  => 'aboutus',
					'type'     => 'text',
					'priority' => 10,
					'default'  => '',
				) );
			
			Kirki::add_field( 'air-free', array(
					'settings' => 'aboutus_image1',
					'label'    => __( 'About us Background Image 1', 'air-free' ),
					'section'  => 'aboutus',
					'type'        => 'image',
					'priority' => 10,
				) );
			
	 /*4th-------------------------------------------------------*/	
		
	 Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'aboutus_heading2',
		'section'     => 'aboutus',
		'default'     => sprintf(__('<div class="section-heading"><a href="%s" target="_blank"> Need More Elements ? <br/> <span> Upgrade to pro </span> </a></div>', 'air-free'),$pro_link),
		'priority'    => 10,
		) );
	
	
	/*------------------------------------------
		 Home Page Testimonial Section	
	------------------------------------------*/
			
		Kirki::add_section( 'homepage_testimonial', array(
			'title'          => __( 'Testimonials', 'air-free' ),
			'description'    => __( 'From here you can manage Testimonials', 'air-free' ),
			'panel'          => 'homepage', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
		

	Kirki::add_field( 'air-free', array(
			'settings' => 'showin_menu_testimonial',
			'label'    => __( 'Show in Menu ? ', 'air-free' ),
			'section'  => 'homepage_testimonial',
			'type'     => 'toggle',
			'priority' => 10,
			'default' => 1,
		) );		
		 					
  		Kirki::add_field( 'air-free', array(
				'settings' => 'testimonials_menu_title',
				'label'    => __( 'Testimonial Menu Text', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'Testimonials', 
			 
		 ) );		
			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_title',
				'label'    => __( 'Testimonial Title', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'Testimonials', 
			 
		 ) );
			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_text',
				'label'    => __( 'Testimonial Text', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'textarea',
				'priority' => 10,
				'default'  => '', 
			 
		 ) );
		 
		 
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimonial_image',
				'label'    => __( 'Testimonial Image', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'image',
				'priority' => 10,
				'default'  => image("testimonial.jpg"), 
			 
		 ) );		
		 
/*		 
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_interval',
				'label'    => __( 'Slide Interval', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 5, 
			 
		 ) );*/
 	
	
	 /*1st---------------------------------------------------*/	
	  	
		Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'client_block1',
		'section'     => 'homepage_testimonial',
		'default'     => '<div class="section-heading">Client 1<sup>st</sup> Block</div>',
		'priority'    => 10,
	
		) );
			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_image1',
				'label'    => __( 'Client Image 1', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'image',
				'priority' => 10,
		 ) );		
 			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_client1',
				'label'    => __( 'Client 1', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => '', 
			 
		 ) );
		 
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_text1',
				'label'    => __( 'Testimonial 1', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'textarea',
				'priority' => 10,
				'default'  => '', 
			 
			) );
	 
	 /*2nd---------------------------------------------------*/
	 	
		Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'client_block2',
		'section'     => 'homepage_testimonial',
		'default'     => '<div class="section-heading">Client 2<sup>nd</sup> Block</div>',
		'priority'    => 10,
		) );
			 			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_image2',
				'label'    => __( 'Client Image 2', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'image',
				'priority' => 10,
			 
		 ) );		
 			
			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_client2',
				'label'    => __( 'Client 2', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => '', 
			 
		 ) );
		 
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_text2',
				'label'    => __( 'Testimonial 2', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'textarea',
				'priority' => 10,
				'default'  => '', 
			 
			) );
		
	 /*3rd---------------------------------------------------*/		
	
		Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'client_block3',
		'section'     => 'homepage_testimonial',
		'default'     => '<div class="section-heading">Client 3<sup>rd</sup> Block</div>',
		'priority'    => 10,
		) );
			 	
	  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_image3',
				'label'    => __( 'Client Image 3', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'image',
				'priority' => 10,
			 
		 ) );		
 				
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_client3',
				'label'    => __( 'Client 3', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 10,
				'default'  => '', 
			 
		 ) );
		 
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_testimoial_text3',
				'label'    => __( 'Testimonial 3', 'air-free' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'textarea',
				'priority' => 10,
				'default'  => '', 
			 
			) );
	
	 /*4th---------------------------------------------------*/		

		
 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'client_block4',
		'section'     => 'homepage_testimonial',
		'default'     => sprintf(__('<div class="section-heading"><a href="%s" target="_blank"> Need More Elements ? <br/> <span> Upgrade to pro </span> </a></div>', 'air-free'), $pro_link),
		'priority'    => 10,
		) );
	
	/*------------------------------------------
		 Home Page Services
	------------------------------------------*/
			
		Kirki::add_section( 'homepage_services', array(
			'title'          => __( 'Services', 'air-free' ),
			'description'    => __( 'From here you can manage Services', 'air-free' ),
			'panel'          => 'homepage', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
		
	Kirki::add_field( 'air-free', array(
			'settings' => 'showin_menu_services',
			'label'    => __( 'Show in Menu ? ', 'air-free' ),
			'section'  => 'homepage_services',
			'type'     => 'toggle',
			'default'     => 1,
			'priority' => 10,
		) );		
					
  		Kirki::add_field( 'air-free', array(
				'settings' => 'services_menu_title',
				'label'    => __( 'Services Menu Text', 'air-free' ),
				'section'  => 'homepage_services',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'Services', 
			 
		 ) );
		 			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_services_title',
				'label'    => __( 'Services Title', 'air-free' ),
				'section'  => 'homepage_services',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'Services', 
			 
		 ) );
			
  		Kirki::add_field( 'air-free', array(
				'settings' => 'homepage_services_text',
				'label'    => __( 'Services Text', 'air-free' ),
				'section'  => 'homepage_services',
				'type'     => 'textarea',
				'priority' => 10,
				'default'  => '', 
			 
		 ) );
 
 Kirki::add_field( 'air-free', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Services', 'air-free' ),
		'description' => __( '<h2>How to add icons?</h2><p><strong><ol><li>Go to the Font Awesome website <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">here</a>.</li><li>Find the icon you want to use and click on it.</li><li>Copy the icon\'s class which is in a rectangular box. For example <i>fa-coffee</i>.</li><li>Paste it in the Icon Class field.</li></ol></strong></p>' , 'air-free' ),
 		'section'     => 'homepage_services',
		'priority'    => 10,
		'settings'    => 'services',
 		'fields' => array(
			'service_title' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Services Title', 'air-free' ),
				'description' => esc_attr__( 'This will be the title for your Services', 'air-free' ),
				'default'     => '',
			),
			'service_icon' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Services Icon Class', 'air-free' ),
				'description' => esc_attr__( 'This will be the icon for your Services', 'air-free' ),
				'default'     => '',
			),
			'service_text' => array(
				'type'        => 'textarea',
				'label'       => esc_attr__( 'Services Text', 'air-free' ),
				'description' => esc_attr__( 'This will be the text of Services', 'air-free' ),
				'default'     => '',
			),
		)
	) );


	
	/*------------------------------------------
		 Home Page Statistics
	------------------------------------------*/
			
		Kirki::add_section( 'homepage_statistics', array(
			'title'          => __( 'Statistics', 'air-free' ),
			'description'    => __( 'From here you can manage Statistics', 'air-free' ),
			'panel'          => 'homepage', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
		
	Kirki::add_field( 'air-free', array(
			'settings' => 'showin_menu_statistics',
			'label'    => __( 'Show in Menu ? ', 'air-free' ),
			'section'  => 'homepage_statistics',
			'type'     => 'toggle',
			'default'     => 1,
			'priority' => 10,
		) );		
					
  		Kirki::add_field( 'air-free', array(
				'settings' => 'statistics_menu_title',
				'label'    => __( 'Statistics Menu Text', 'air-free' ),
				'section'  => 'homepage_statistics',
				'type'     => 'text',
				'priority' => 10,
				'default'  => 'Statistics', 
			 
		 ) );
		 			
   
 Kirki::add_field( 'air-free', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Services', 'air-free' ),
		'description' => __( '<h2>How to add icons?</h2><p><strong><ol><li>Go to the Font Awesome website <a href="http://fortawesome.github.io/Font-Awesome/icons/" target="_blank">here</a>.</li><li>Find the icon you want to use and click on it.</li><li>Copy the icon\'s class which is in a rectangular box. For example <i>fa-coffee</i>.</li><li>Paste it in the Icon Class field.</li></ol></strong></p>' , 'air-free' ),
 		'section'     => 'homepage_statistics',
		'priority'    => 10,
		'settings'    => 'statistics',
 		'fields' => array(
			'stats_title' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Statistics Title', 'air-free' ),
				'description' => esc_attr__( 'This will be the title for your Statistics', 'air-free' ),
				'default'     => '',
			),
			'stats_icon' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Statistics Icon Class', 'air-free' ),
				'description' => esc_attr__( 'This will be the icon for your Statistics', 'air-free' ),
				'default'     => '',
			),
			'stats_no' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Statistics Number', 'air-free' ),
				'description' => esc_attr__( 'This will be the Number of Statistics', 'air-free' ),
				'default'     => '',
			),
		)
	) );


	/*------------------------------------------
		 Home Page Plans
	------------------------------------------*/
			
		Kirki::add_section( 'homepage_plans', array(
			'title'          => __( 'Plans', 'air-free' ),
			'description'    => __( 'From here you can manage Plans', 'air-free' ),
			'panel'          => 'homepage', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
		

	
 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'homepage_plans_pro_message',
		'section'     => 'homepage_plans',
		'default'     => $pro_message,
		'priority'    => 10,
		) );
	
	
	/*----------------------------------
		 Portfolio Settings
	*----------------------------------*/
		
	Kirki::add_section( 'homepage_portfolio_settings', array(
		'title'          => __( 'Portfolio Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Portfolio Settings' , 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
	
 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'homepage_portfolio_settings_pro_message',
		'section'     => 'homepage_portfolio_settings',
		'default'     => $pro_message,
		'priority'    => 10,
		) );
 


	/*----------------------------------
		 Team Settings
	*----------------------------------*/
		
	Kirki::add_section( 'homepage_team_settings', array(
		'title'          => __( 'Team Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Team Settings' , 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
 		
	
	 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'homepage_team_settings_pro_message',
		'section'     => 'homepage_team_settings',
		'default'     => $pro_message,	
		'priority'    => 10,
		) );
 

 	/*----------------------------------
		Twitter Settings
	*----------------------------------*/
		
	Kirki::add_section( 'twitter_settings', array(
		'title'          => __( 'Twitter Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Twitter Settings' , 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );

	 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'twitter_settings_pro_message',
		'section'     => 'twitter_settings',
		'default'     => $pro_message,
		'priority'    => 10,
		) );
 
	
 	/*------------------------------------------
		 Home Page Contact
	------------------------------------------*/
			
		Kirki::add_section( 'homepage_contact', array(
			'title'          => __( 'Contact', 'air-free' ),
			'description'    => __( 'From here you can manage Contact Settings', 'air-free' ),
			'panel'          => 'homepage', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
		
	 Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'homepage_contact_pro_message',
		'section'     => 'homepage_contact',
		'default'     => $pro_message,
		'priority'    => 10,
		) );
 
		

	/*---------------------------------------
		Modules Order
	-----------------------------------------*/
	
	  Kirki::add_section( 'homepage_modules', array(
		'title'          => __( 'Modules order', 'air-free' ),
		'description'    => __( 'You can re-order, enable/disable modules from here', 'air-free' ),
		'panel'          => 'homepage', 
		'priority'       => 170,
		'capability'     => 'edit_theme_options',
	) );
	 
	 
 	Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'homepage_modules_pro_message',
		'section'     => 'homepage_modules',
		'default'     => $pro_message,
		'priority'    => 10,
		) );
 

	/*------------------------------------------
				General Settings 
	------------------------------------------*/
		
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 2,
		'title'       => __( 'General Settings', 'air-free' ),
		'description' => __( 'Manage General Setting from here', 'air-free' ),
	) );
	
	
	/*------------------------------------------
		General Section	
  	------------------------------------------*/
		
	Kirki::add_section( 'general_settings', array(
		'title'          => __( 'General Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Some General Settings' , 'air-free' ),
		'panel'          => 'general_settings', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
 
 	Kirki::add_field( 'air-free', array(
			'settings' => 'pre_loader_switch',
			'label'    => __( 'Pre Loader', 'air-free' ),
			'section'  => 'general_settings',
			'type'     => 'toggle',
			'priority' => 10,
			'default'  => 1,
 		) );	  
	
	
 	 	// Theme Color
		 Kirki::add_field( 'air-free', array(
			'type'        => 'custom',
			'label'       => __( 'Select Color Style', 'air-free' ),
			'settings'     => 'select-style_pro_message',
			'section'     => 'general_settings',
			'default'     => $pro_message,
			'priority'    => 10,
			) );
			
	 Kirki::add_field( 'air-free', array(
			'settings' => 'one_page_switch_pro_message',
			'label'    => __( 'One Page Switch', 'air-free' ),
			'section'  => 'general_settings',
			'type'     => 'custom',
			'priority' => 10,
			'default'     => $pro_message,
		) );		
			
			
 	 	/*Logo----------------------------*/
	
		Kirki::add_section( 'logo_settings', array(
			'title'          => __( 'Logo Settings', 'air-free' ),
			'description'    => __( 'From Here You Can Manage Manage Settings' , 'air-free' ),
			'panel'          => 'general_settings', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options',
		) );
	

		Kirki::add_field( 'air-free', array(
				'settings' => 'logo',
				'label'    => __( 'Logo', 'air-free' ),
				'description'    => __( 'Optimum Size for logo is 70x28 px' , 'air-free' ),
				'section'  => 'logo_settings',
				'type'     => 'image',
				'priority' => 10,
				//'default'  => image('logo-white.png'),
			 
			) );
			
	
		/*----------------------------------
			Menu Settings
		*----------------------------------*/
			
		Kirki::add_section( 'menu_settings', array(
			'title'          => __( 'Menu Settings', 'air-free' ),
			'description'    => __( 'From Here You Can Manage Menu Settings' , 'air-free' ),
			'panel'          => 'general_settings', 
			'priority'       => 160,
			'capability'     => 'edit_theme_options', 
		) );
		
		Kirki::add_field( 'air-free', array(
			'settings' => 'nav_menu_name',
			'label'    => __( 'Choose a Menu', 'air-free' ),
			'section'  => 'menu_settings',
			'type'     => 'select',
			'priority' => 10,
			'choices'     => $nav_menus
		) );	
		
		
		Kirki::add_field( 'air-free', array(
		'settings' => 'nav_menu_position_pro_message',
		'label'    => __( 'Choose Menu Position', 'air-free' ),
		'section'  => 'menu_settings',
		'type'     => 'custom',
		'priority' => 9,
		'default'     => $pro_message,
	) );
			
		
 	 Kirki::add_field( 'air-free', array(
				'settings' => 'floatmenu_pro_message',
				'label'    => __( 'Float menu ? ', 'air-free' ),
				'section'  => 'menu_settings',
				'type'     => 'custom',
				'priority' => 10,
				'default'     => $pro_message,
	 		) );	

		

 	/* Social Settings --------------------------*/
	
		Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Social Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'air-free' ),
		'panel'          => 'general_settings', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
	
		Kirki::add_field( 'air-free', array(
				'settings' => 'social_facebook',
				'label'    => __( 'Facebook', 'air-free' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 10,
				'default'  => '#',
	 		) );
	
		Kirki::add_field( 'air-free', array(
				'settings' => 'social_twitter',
				'label'    => __( 'Twitter', 'air-free' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 10,
				'default'  => '#',
			) );
	
		Kirki::add_field( 'air-free', array(
				'settings' => 'social_pinterest',
				'label'    => __( 'Pinterest', 'air-free' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 10,
				'default'  => '#',
				 
			 
			) );
	 
	 	Kirki::add_field( 'air-free', array(
				'settings' => 'social_tumblr',
				'label'    => __( 'Tumblr', 'air-free' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 10,
				'default'  => '#',
			) );

	 /*custom -------------------------------------------------------*/	
		
	 Kirki::add_field( 'air-free', array(
		'type'        => 'custom',
		'settings'     => 'social_youtube',
		'section'     => 'social_settings',
		'default'     => sprintf(__('<div class="section-heading"><a href="%s" target="_blank"> Need More Elements ? <br/> <span> Upgrade to pro </span> </a></div>', 'air-free'),$pro_link),
		'priority'    => 10,
		) );
	
	
 	/*----------------------------------
		Footer Setting
	*----------------------------------*/
		
	Kirki::add_section( 'footer_settings', array(
		'title'          => __( 'Footer Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Footer Settings' , 'air-free' ),
		'panel'          => 'general_settings', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
		
		Kirki::add_field( 'air-free', array(
				'settings' => 'footer_copyright',
				'label'    => __( 'Footer Copyright', 'air-free' ),
				'section'  => 'footer_settings',
				'type'     => 'editor',
				'default'  => __('Theme by <a href="http://www.navthemes.com/">NavThemes</a>.', 'air-free'), 
				'priority' => 10,
	 		) );	
	 
	
	/*----------------------------------
		Advance Setting
	*----------------------------------*/
		
	Kirki::add_section( 'advance_settings', array(
		'title'          => __( 'Advance Settings', 'air-free' ),
		'description'    => __( 'From Here You Can Manage Advance Settings' , 'air-free' ),
		'panel'          => 'general_settings', 
		'priority'       => 160,
		'capability'     => 'edit_theme_options', 
	) );
	
	
		 Kirki::add_field( 'air-free', array(
			'type'        => 'custom',
			'settings'     => 'advance_settings_pro_message',
			'section'     => 'advance_settings',
			'default'     => $pro_message,
			'priority'    => 10,
			) );
	
/*------------------------------------------
 	Customizer CSS
------------------------------------------*/ 	
	
 	function customizer_css() {
		// Loads our main stylesheet.
		wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' ); 
	}
	
	add_action( 'customize_controls_print_styles', 'customizer_css');

/*----------------------------------------------------------------------------------------------------*/